IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_NF_SAI_LIBERACAO_ENTRADA]') AND type in (N'U'))
begin
CREATE TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA](
	[CD_CTR_LIBERACAO] [int] IDENTITY(1,1) NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_NF] [int] NOT NULL,
	[CD_USU] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	ERROS_XML XML NOT NULL,
 CONSTRAINT [PK_EST_NF_SAI_LIBERACAO_ENTRADA] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_LIBERACAO] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA] ADD  CONSTRAINT [DF_EST_NF_SAI_LIBERACAO_ENTRADA_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA] ADD  CONSTRAINT [DF_EST_NF_SAI_LIBERACAO_ENTRADA_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA] ADD  CONSTRAINT [DF_EST_NF_SAI_LIBERACAO_ENTRADA_CD_NF]  DEFAULT ((0)) FOR [CD_NF]

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA] ADD  CONSTRAINT [DF_EST_NF_SAI_LIBERACAO_ENTRADA_CD_USU]  DEFAULT ((0)) FOR [CD_USU]

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA] ADD  CONSTRAINT [DF_EST_NF_SAI_LIBERACAO_ENTRADA_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA]  WITH CHECK ADD  CONSTRAINT [FK_EST_NF_SAI_LIBERACAO_ENTRADA_EST_NF_SAI] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_NF])
REFERENCES [dbo].[EST_NF_SAI] ([CD_EMP], [CD_FILIAL], [CD_NF])
ON DELETE CASCADE

ALTER TABLE [dbo].[EST_NF_SAI_LIBERACAO_ENTRADA] CHECK CONSTRAINT [FK_EST_NF_SAI_LIBERACAO_ENTRADA_EST_NF_SAI]
end

